%%%% Perfected notes converted to modern notation with dots
%%%% Also to facillitate typesetting of full bar rests

%%% Minor Prolation

%%% Closed circle (Tempus Perfectum, Minor Prolatio)
OSemibreveA = #(ly:make-duration 0 0 2/1) %Altered semibreve

OBreve = #(ly:make-duration -1 0 3/2)

OLongaP = #(ly:make-duration -2 0 9/4) %Modus Perfectus,1 L = 3 B = 9 S = 18M

OLongaI = #(ly:make-duration -2 0 3/2) %Modus Perfectus,1 L = 2 B = 6 S = 12M

OBRest = r\breve*3/2 %B rest in O mensuration

OThreeBRest = r\longa*9/4 %L Rest that takes three ledger spaces

OTwoBRest = r\longa*3/2 %L Rest that takes two ledger spaces

%%% Open Circle (Tempus Imperfectum, Minor Prolatio)

CLongaP = #(ly:make-duration -3 0 3/2) %Modus Perfectus,1L = 3B = 6S

CBRest = r\breve

CTwoBRest = r\longa

CThreeBRest = r\longa*3/2

%%% Major Prolation

SemibreveP = #(ly:make-duration 0 0 3/2)

MinimA = #(ly:make-duration 1 0 2/1)

SRestP = r1*3/2 %S rest in major prolation

%%% Closed circle with dot (Tempus Perfectum, Major Prolatio)

ODBreve = #(ly:make-duration -1 0 9/4) %TP, Major Prolation 1 B = 3 S = 9 M

ODBRest = r\breve*9/4 %S rest in O dot mensuration

%%% Open circle with dot (Tempus Imperfectum, Major Prolatio)

CDBreve = #(ly:make-duration -1 0 3/2) %TP, Major Prolation 1 B = 2 S = 6 M

CDBRest = r\breve*3/2

%%% Miscellaneous

%%% Define the notes used in minor colouration

bblack = #(ly:make-duration -1 0 3/4) %Blackened breve always in ligature

sbblack = #(ly:make-duration 0 0 3/4) %Blackened S, always followed by blackened M

sbblackII = #(ly:make-duration 0 0 1/1)

mblack = #(ly:make-duration 2 0 1/1) %Blackened M which follows S

SBdottedM = \defineTransform {c'2. d'4}

longaTPMP = #(ly:make-duration -2 0 5/4)

%%% Functions used to define note lengths in minor colouration
sbn = \defineTransform {c'1}

bb = \defineTransform {c'\bblack}
  
sbb = \defineTransform {c'\sbblack}

sbbII = \defineTransform {c'\sbblackII}

mbl = \defineTransform {c'\mblack}

%%% Minor colouration with S and M
sbdm =
#(define-music-function
     (parser location note-I note-II)
     (ly:music? ly:music?)
   #{
  \petrbl <>\startTextSpan \sbb #note-I <>\stopTextSpan \mbl #note-II
  \petrble
#})

%%% Minor colouration with S and M, S inside ligature

lgsbdm = 
#(define-music-function
     (parser location note-I note-II note-III)
     (ly:music? ly:music? ly:music?)
   #{
  \[ #note-I \petrbl \hbd <>\startTextSpan \sbb #note-II <>\stopTextSpan\]
  \mbl #note-III
  \petrble
#})

lsbdm = 
#(define-music-function
     (parser location note-I note-II note-III)
     (ly:music? ly:music? ly:music?)
   #{
  \lgsbdm { \sbn #note-I } #note-II #note-III
#})

%%% Minor colouration with B and S

bdsb =  
#(define-music-function
     (parser location note-I note-II)
     (ly:music? ly:music?)
   #{
  \petrbl <>\startTextSpan \bb #note-I <>\stopTextSpan \sbbII #note-II
  \petrble
#})

bmm =  
#(define-music-function
     (parser location note-I note-II note-III)
     (ly:music? ly:music? ly:music?)
   #{
  \petrbl <>\startTextSpan \bb #note-I \mbl #note-II <>\stopTextSpan
  \mbl #note-III
  \petrble
#})

lgbmm =  
#(define-music-function
     (parser location note-I note-II note-III note-IV)
     (ly:music? ly:music? ly:music? ly:music?)
   #{
  \[ #note-I \petrbl <>\startTextSpan \bb #note-II \]
  \mbl #note-III <>\stopTextSpan
  \mbl #note-IV
  \petrble
#})

%%% Function to typeset correctly M and SM with
%%% empty notehead in prefect prolation
%%% No effect in modern transcrition
wn = 
#(define-music-function
     (parser location white-notes)
     (ly:music?)
   #{
  \override NoteHead.stencil = #ly:text-interface::print
  \override NoteHead.text = \markup {\musicglyph #"noteheads.s1petrucci" }
  \shiftDurations #1 #0 { #white-notes }
  \revert NoteHead.stencil
#})  
