%%% Implementation of a prefix tree in scheme to store music
%%% Modified copy of original code writtey by Jan-Peter Voigt
%%% http://lilypondblog.org/2014/07/trees-music-and-lilypond/

\version "2.18.2"
%%% \include "typesetting_functions.ly"

%%% the main music tree
musicTree = #'()

%%% function to store music in `musicTree`
putMusic =
#(define-void-function (parser location path content)(string? ly:music?)
   (let ((pl (string->path path)))
     (set! musicTree (tree-set! musicTree pl content))
     ))

%%% function to get music from `musicTree`
getMusic =
#(define-music-function (parser location path)(string?)
   (let* ((pl (string->path path))
          (content (tree-get musicTree pl)))
     (if (ly:music? content) content (make-music 'SequentialMusic 'void #t))
     ))

%%% set a value in a tree -- based on nested association lists
#(define-public (tree-set! tree path val)
   (if (> (length path) 1)
       (let ((tab (assoc (car path) tree)))
         (if (not (pair? tab))(set! tab '((car path))))
         (assoc-set! tree (car path) (tree-set! (cdr tab) (cdr path) val))
         )
       (assoc-set! tree (car path) val))
   )

%%% get a value from a tree -- based on nested association lists
#(define-public (tree-get tree path)
   (let ((ret (assoc (car path) tree)))
     (if (pair? ret)
         (if (> (length path) 1)
             (tree-get (cdr ret) (cdr path))
             (cdr ret))
         #f))
   )

%%% split a string by '/'
#(define-public (string->path str)(string-split str #\/))

%%% helper function to append strings
stringAppend =
#(define-scheme-function (parser location str1 str2)(string? string?)
   (string-append str1 str2))

%%% create one vocal staff
vocalStaff =
#(define-music-function (parser location my-path-to-vocal)(string?)
   ; create a unique name for the voice
   (let ((voice-name my-path-to-vocal))
     #{
       <<
         \new Staff
         \with {\consists "Ambitus_engraver"}
         \new Voice = #voice-name
         <<
         \incipit {\incBoiler {\keepWithTag #'ori \getMusic \stringAppend #my-path-to-vocal "/incipit"}}
         { \musBoiler {\getMusic \stringAppend #my-path-to-vocal "/melody"}}
         >>
         \new Lyrics \lyricsto #voice-name { \getMusic \stringAppend #my-path-to-vocal "/lyrics" }
       >>
     #}))

%%% Create one vocal staff without incipit
%%% takes additional msuci that it places before the melody proper
vocalStaffNoInc =
#(define-music-function (parser location my-path-to-vocal name-clef)(string? ly:music?)
   ; create a unique name for the voice
   (let ((voice-name my-path-to-vocal))
     #{
       <<
         \new Staff
         \with {\consists "Ambitus_engraver"}
         \new Voice = #voice-name
         <<
         {\musBoiler {\getMusic \stringAppend #my-path-to-vocal "/melody"} { $name-clef } {}}
         >>
         \new Lyrics \lyricsto #voice-name { \getMusic \stringAppend #my-path-to-vocal "/lyrics" }
       >>
     #}))

%%% Typeset chants in modern format
chantMovt =
#(define-music-function
     (parser location movement)
     (string?)
   #{
  \chantBoiler
  \getMusic \stringAppend #movement "/melody"
  \getMusic \stringAppend #movement "/lyrics"
#}
)

%%% A generic staffgroup creator that unfolds a list of voices
%%% and gives them their own staff
genericStaffGroup =
#(define-music-function
  (parser location my-path-to-choir path-list)
  (string? list?)
  #{
  \shiftDurations #1 #0 {
  \new StaffGroup = ChoirStaff <<
  $(make-music 'SimultaneousMusic 'elements
    (map (lambda (staff)
	  #{ \vocalStaff #(string-append my-path-to-choir staff) #}) path-list))
  >>
  }
  #})

%%% These following staffgroups with specific number were defined 
%%% for convenience and legacy reasons

Duet =
#(define-music-function (parser location my-path-to-choir v-one v-two)(string? string? string?)
   #{ \genericStaffGroup #my-path-to-choir #(list v-one v-two) #})

Trio =
#(define-music-function (parser location my-path-to-choir v-one v-two v-three)(string? string? string? string?)
   #{ \genericStaffGroup #my-path-to-choir #(list v-one v-two v-three) #})

Quartet =
#(define-music-function (parser location my-path-to-choir v-one v-two v-three v-four)(string? string? string? string? string?)
   #{ \genericStaffGroup #my-path-to-choir #(list v-one v-two v-three v-four) #})

Quintet =
#(define-music-function (parser location my-path-to-choir v-one v-two v-three v-four v-five)(string? string? string? string? string? string?)
   #{ \genericStaffGroup #my-path-to-choir #(list v-one v-two v-three v-four v-five) #})

Sextet =
#(define-music-function (parser location my-path-to-choir v-one v-two v-three v-four v-five v-six)(string? string? string? string? string? string? string?)
   #{ \genericStaffGroup #my-path-to-choir #(list v-one v-two v-three v-four v-five v-six) #})

Septet =
#(define-music-function (parser location my-path-to-choir v-one v-two v-three v-four v-five v-six v-seven)(string? string? string? string? string? string? string? string?)
   #{ \genericStaffGroup #my-path-to-choir #(list v-one v-two v-three v-four v-six v-seven) #})

Octet =
#(define-music-function (parser location my-path-to-choir v-one v-two v-three v-four v-five v-six v-seven v-eight)(string? string? string? string? string? string? string? string? string?)
   #{ \genericStaffGroup #my-path-to-choir #(list v-one v-two v-three v-four v-five v-six v-seven v-eight) #})