%%% Mensural Tight Setting from Black Mensural
%%% By Lukas Pietsch
mensuralTightSetting = {
  \override Score.SpacingSpanner #'base-shortest-duration = #(ly:make-moment 1 2)
  \override Score.SpacingSpanner #'common-shortest-duration = #(ly:make-moment 1 2)
  \override Score.SpacingSpanner #'shortest-duration-space = #1.5
  \override Score.SpacingSpanner #'spacing-increment = #0.05
  \override NoteSpacing    #'stem-spacing-correction = #0.0
  \override Score.BarLine #'stencil = #empty-stencil
  \override Score.BarNumber #'stencil = #empty-stencil
}

% Boilerplote for Typesetting the incipit
% Arguments : music clef
incBoiler =
#(define-music-function
     (parser location inc-music)
     (ly:music?)
   #{
<<
  \new MensuralVoice <<
    %\repeat unfold 9 { s1 \noBreak }
    {
      \set Score.timing = ##f
      \override NoteHead.style = #'petrucci
      \override Rest.style = #'mensural
      \override Staff.TimeSignature.style = #'mensural
      \mensuralTightSetting
      $inc-music
      s\breve
    }
  >>
>>
#})

% Hiding incipits when one part is canonically generated
hideIncipit = {
  \omit Staff.Clef
  \omit Staff.TimeSignature
  \omit Staff.KeySignature
  \override Staff.StaffSymbol.color = #white
}

% Boilerplate for Typesetting Music in Modern Staff
% Arguments : music clef
musBoiler =
#(define-music-function
     (parser location sub-music)
     (ly:music?)
   #{
  \override NoteHead.style = #'baroque
  \set Staff.midiInstrument = #"acoustic grand"
  \override Staff.BarLine #'transparent = ##t
  \override Score.BarNumber.break-visibility = #end-of-line-invisible
  \set Score.barNumberVisibility = #(every-nth-bar-number-visible 5)
  \override Score.BarNumber.self-alignment-X = #LEFT
  \override Score.BarNumber.stencil
    = #(make-stencil-circler 0.15 0.4 ly:text-interface::print)
  \expandFullBarRests
  \accidentalStyle forget
  $sub-music
  \override Staff.BarLine #'transparent =##f
  \bar "|." 
#}
)

%%% Boilerplate for Typesetting in Original notation
musBoilerOri =
#(define-music-function
     (parser location sub-music)
     (ly:music?)
   #{
  \override NoteHead.style = #'petrucci
  \override Rest.style = #'mensural
  \override Staff.TimeSignature.style = #'mensural
  \mensuralTightSetting
  \stemUp
  \cadenzaOn
  \accidentalStyle forget
  $sub-music
#})

% Boilerplate for Typesetting Chants
% Arguments : music, text
chantBoiler =
#(define-music-function (parser location chant-music chant-text) (ly:music? ly:music?)
  #{
  \new Staff <<
  \new Voice  = "melody" \with {
  \remove "Forbid_line_break_engraver"
} {
  \clef "G_8"
  \key c \major
  \set Score.timing = ##f
  \slurUp
  $chant-music
  }
  \new Lyrics = "one" \lyricsto melody $chant-text
>>
  #})

%Function to typeset incipit properly
%%%%%%%%%%%%%%%%%%%%%%%%
incipit =
#(define-music-function (parser location incipit-music) (ly:music?)
  #{
  \once \override Staff.InstrumentName.self-alignment-X = #RIGHT
  \once \override Staff.InstrumentName.self-alignment-Y = ##f
  \once \override Staff.InstrumentName.padding = #0.3
  \once \override Staff.InstrumentName.stencil =
  #(lambda (grob)
    (let* ((instrument-name (ly:grob-property grob 'long-text)))
     (set! (ly:grob-property grob 'long-text)
      #{ \markup
      \score
      {
      { \new MensuralStaff \with {
      \once \override Staff.InstrumentName.self-alignment-X = #CENTER
      \once \override Staff.InstrumentName.self-alignment-Y = #-0.7
      instrumentName = \markup {
      \center-column {
      \with-color #white "___________"
      #instrument-name
      }
      }
    } $incipit-music
    }
      \layout { $(ly:grob-layout grob)
      line-width = \indent
      indent =
				% primitive-eval is probably easiest for
				% escaping lexical closure and evaluating
				% everything respective to (current-module).
      #(primitive-eval
	'(or (false-if-exception (- indent incipit-width))
	  (* 0.5 indent)))
		ragged-right = ##f
		ragged-last = ##f
		system-count = #1 }
    }
	 #})
  (system-start-text::print grob)))
  #})

%Function to repeat rhythms on different pitches
%Taken from http://lsr.di.unimi.it/LSR/Item?id=346
defineTransform =
#(define-scheme-function (parser location pattern)
   (ly:music?)
   (define-music-function (parser location pitchseq)
     (ly:music?)
     (let ((pitches (list->vector
                     (reverse!
                      (fold-some-music
                       (lambda (m)
                         (ly:pitch? (ly:music-property m 'pitch)))
                       (lambda (m l)
                         (cons (ly:music-property m 'pitch) l))
                       '()
                       pitchseq))))
           (m (ly:music-deep-copy pattern)))
       (for-some-music
        (lambda (m)
          (let ((p (ly:music-property m 'pitch)))
            (and (ly:pitch? p)
                 (begin
                   (set! (ly:music-property m 'pitch)
                         (vector-ref pitches
                                     (ly:pitch-steps p)))
                   #t))))
        m)
       m)))

%%% Define note equivalence in tempo markup
#(define-markup-command (note-equiv layout props note-p note-n) (string? string?)
  "Draw a double box around text."
  (interpret-markup layout props
   #{
   \markup {
   \concat {
   (
     \smaller \general-align #Y #DOWN \note #note-p #1
     \hspace #0.4 \char ##x2190 " = " \char ##x2192 \hspace #0.4
     \smaller \general-align #Y #DOWN \note #note-n #1
   )
 }
 }
   #}))


%%% Functions to surround lyric hypens and extenders with white box
%%% Taken from https://lists.gnu.org/archive/html/lilypond-user/2008-05/msg00153.html By Mats Bengtsson
% Copied from scm/stencil.scm in version 2.11
#(define-public (stencil-with-color stencil color)
 (ly:make-stencil
  (list 'color color (ly:stencil-expr stencil))
  (ly:stencil-extent stencil X)
  (ly:stencil-extent stencil Y)))

% Copied from scm/stencil.scm in version 2.11
% Extended to add some padding around:
#(define (stencil-padded-whiteout stencil padding)
 (let*
     ((x-ext (ly:stencil-extent stencil X))
      (y-ext (ly:stencil-extent stencil Y))

      )

   (ly:stencil-add
    (stencil-with-color (ly:round-filled-box
             (interval-widen x-ext padding)
             (interval-widen y-ext 0.1) 0.0)
                        white)
    stencil)
   ))

#(define (text-in-white-box grob)
 (stencil-padded-whiteout (ly:text-interface::print grob) 0.5))

#(define (lyric-extender-in-white-box grob)
  (if (null? (ly:lyric-extender::print grob))
   '()
   (stencil-padded-whiteout (ly:lyric-extender::print grob) 0.5)))

#(define (lyric-hyphen-in-white-box grob)
 (if (null? (ly:lyric-hyphen::print grob))
  '()
  (stencil-padded-whiteout (ly:lyric-hyphen::print grob) 0.0)))

#(define (extra-padded-hyphens grob)
 (if (null? (ly:lyric-hyphen::print grob))
  '()
  (stencil-padded-whiteout (ly:lyric-hyphen::print grob) 1.0)))

hypPad = {\once \override Score.LyricHyphen.stencil = #extra-padded-hyphens }

%%% Function to allow correctly placement of rests in source  
plre =
#(define-music-function
     (parser location rest dis)
     (ly:music? number?)
   #{
  \tag #'ori {
  \override Score.Rest.Y-offset = #dis
  #rest
  \revert Score.Rest.Y-offset
}
  \tag #'mod { #rest }
#})

%%% Function to increase padding of parentheses of dotted notes
parPad = {
  \once \override Score.ParenthesesItem.padding = #0.7
  \once \override Score.ParenthesesItem.extra-offset = #'(0.35 . 0)
}

%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Enable flexa ligatures
flex = {
    \override NoteHead.flexa-width = #3
    \override NoteHead.ligature-flexa = ##t
}

flexe = {
  \revert NoteHead.ligature-flexa
}

%%% Make colouration brackets down to avoid collision
hbd = {
  \once \override TextSpanner.direction = #DOWN
  \once \override TextSpanner.bound-details.left.text =
  \markup { \combine
	    \override #'(thickness . 2)
	    \draw-line #'(0 . 1)
	    \override #'(thickness . 2)
	    \draw-line #'(1 . 0) }
  \once \override TextSpanner.bound-details.right.text =
  \markup { \combine
	    \override #'(thickness . 2)
	    \draw-line #'(0 . 1)
	    \override #'(thickness . 2)
	    \draw-line #'(-1 . 0)}
  \override TextSpanner.style = #'none
}

%%% Black mensural notation for English choirbooks and 
%%% colouration. Discarded in modern transcription
  petrbl = {
    \tag #'mod {}
    \tag #'ori  {
      \override NoteHead.style = #'blackpetrucci
    }
  }

  petrble = {
    \tag #'mod {}
    \tag #'ori {
      \override NoteHead.style = #'petrucci
    }
  }

%%% Red coloration for English choirbooks
%%% Discarded in Modern transcription
rn = {
  \tag #'mod {
    <>\startTextSpan
  }
  \tag #'ori {
    \override NoteHead.color = #red
    \override Stem.color = #red
    \override Dots.color = #red
  }
}

rne = {
  \tag #'mod {
    <>\stopTextSpan
  }
  \tag #'ori {
    \revert NoteHead.color
    \revert Stem.color
    \revert Dots.color
  }
}

%%% Function for editorial accidentals
fic = { \once \set suggestAccidentals = ##t }
it=\override LyricText.font-name = #"EB Garamond Italic"
ite=\override LyricText.font-name = #"EB Garamond"

%%% Shorthand for starting and ending melismas
m = \melisma
me = \melismaEnd

%%% Glyphs for typesetting incipits with diminuted forms of time signatures
noTS = {
\override Staff.TimeSignature.color = #white
\override Staff.TimeSignature.layer = #-1
}

%%% Stop printing bar lines after the final long
  noBar = {
    \set Timing.defaultBarType = ""
    \override Score.BarNumber.break-visibility = ##(#f #f #f)
  }

%The simple proportion of minor prolation mensural signs
Omens = \markup {\musicglyph #"timesig.mensural32"}
CutO = \markup {\musicglyph #"timesig.mensural34"}
Cmens = \markup {\musicglyph #"timesig.mensural44"}
CutC = \markup {\musicglyph #"timesig.mensural22"}
Cbac = \markup {\musicglyph #"timesig.mensural48"}
Cdot = \markup {\musicglyph #"timesig.mensural64"}
Odot = \markup {\musicglyph #"timesig.mensural94"}
CutCdot = \markup {\musicglyph #"timesig.mensural68"}
CutOdot = \markup {\musicglyph #"timesig.mensural98"}

OThree =
  \markup{
    \combine
    \musicglyph #"timesig.mensural32"
    \translate #'(1.7 . -0.8) 3
  }

OThreeAlt =
  \markup{
    \combine
    \translate #'(0 . 1.5 )\musicglyph #"timesig.mensural32"
    \translate #'(0.2 . -1) 3
  }

CThree =
  \markup{
    \combine
    \musicglyph #"timesig.mensural44"
    \translate #'(1.7 . -0.8) 3
  }

CutCThree =
  \markup{
    \combine
    \musicglyph #"timesig.mensural22"
    \translate #'(1.7 . -0.8) 3
  }

CutCThreeTwo =
  \markup{
    \combine
    \combine
    \musicglyph #"timesig.mensural22"
    \translate #'(1.7 . 0.2) 3
    \translate #'(1.7 . -1.8) 2
  }

CTwo =
  \markup{
    \combine
    \musicglyph #"timesig.mensural44"
    \translate #'(1.7 . -0.8) 2
  }

CutCTwo =
  \markup{
    \combine
    \musicglyph #"timesig.mensural22"
    \translate #'(1.7 . -0.8) 2
  }

OTwo =
  \markup{
    \combine
    \musicglyph #"timesig.mensural32"
    \translate #'(1.7 . -0.8) 2
  }

%%% Pick Time Signature stencil (see above for the symbols)
timeSigSymb = 
#(define-music-function
     (parser location glyph)
     (markup?)
   #{
  \once \override Staff.TimeSignature.stencil = #ly:text-interface::print
  \once \override Staff.TimeSignature.text = #glyph
  #})

#(define-markup-command (five-signs layout props sign-I sign-II sign-III sign-IV sign-V) (markup? markup? markup? markup? markup?)
  "Draw a double box around text."
  (interpret-markup layout props
    #{\markup
   \combine
   \raise #4.2 #sign-I
   \combine
   \raise #2.2 #sign-II
   \combine
   #sign-III
   \combine
   \lower #2.2 #sign-IV
   \lower #4.6 #sign-V
   #}))  

#(define-markup-command (four-signs layout props sign-I sign-II sign-III sign-IV) (markup? markup? markup? markup?)
  "Draw a double box around text."
  (interpret-markup layout props
    #{\markup
   \combine \raise #3.2 #sign-I
   \combine
   \raise #1 #sign-II
   \combine
   \lower #1.2 #sign-III
   \lower #3.6 #sign-IV
   #}))

#(define-markup-command (three-signs layout props sign-I sign-II sign-III) (markup? markup? markup?)
  "Draw a double box around text."
  (interpret-markup layout props
    #{\markup
   \combine \raise #2.2 #sign-I
   \combine
   #sign-II
   \lower #2.2 #sign-III
   #}))

#(define-markup-command (two-signs layout props sign-I sign-II) (markup? markup?)
  "Draw a double box around text."
  (interpret-markup layout props
   #{
   \markup \three-signs #sign-I "" #sign-II
   #}))
%%% Scales for modal transpositions
diatonicScale = \relative c' {
  c d e f g a b
  }

bmolleScale = \relative c' {
  f g a bes c d e
}
%%% Adding text underlay in the same section as the music  
lyr =
#(define-music-function
     (parser location text)
     (markup?)
  #{
  <>-\tag #'oriText _\markup #text
#}
)

%%%% Perfected notes converted to modern notation with dots
%%%% Also to facillitate typesetting of full bar rests

%%% Minor Prolation

%%% Closed circle (Tempus Perfectum, Minor Prolatio)
OSemibreveA = #(ly:make-duration -1 0 1/1) %Altered semibreve

OBreve = #(ly:make-duration -1 1 1/1)

OLongaP = #(ly:make-duration -3 0 9/8) %Modus Perfectus,1 L = 3 B = 9 S = 18M

OLongaI = #(ly:make-duration -2 1 1/1) %Modus Perfectus,1 L = 2 B = 6 S = 12M

OBRest = R\breve. %B rest in O mensuration

OThreeBRest = R\breve.*3 %L Rest that takes three ledger spaces

OTwoBRest = R\breve.*2 %L Rest that takes two ledger spaces

%%% Open Circle (Tempus Imperfectum, Minor Prolatio)

CLongaP = #(ly:make-duration -3 1 1/1) %Modus Perfectus,1L = 3B = 6S

CBRest = R\breve

CTwoBRest = R\breve*2 

CThreeBRest = R\breve*3

%%% Major Prolation

SemibreveP = #(ly:make-duration 0 1 1/1)

MinimA = #(ly:make-duration 0 0 1/1)

SRestP = R1. %S rest in major prolation

%%% Closed circle with dot (Tempus Perfectum, Major Prolatio)

ODBreve = #(ly:make-duration -1 0 9/4) %TP, Major Prolation 1 B = 3 S = 9 M

ODBRest = R1.*3 %S rest in O dot mensuration

%%% Open circle with dot (Tempus Imperfectum, Major Prolatio)

CDBreve = #(ly:make-duration -1 1 1/1) %TP, Major Prolation 1 B = 2 S = 6 M

CDBRest = R1.*2

%%% Miscellaneous

%%% Define the notes used in minor colouration

bblack = #(ly:make-duration 0 1 1/1) %Blackened breve always in ligature

sbblack = #(ly:make-duration 1 1 1/1) %Blackened S, always followed by blackened M

sbblackII = #(ly:make-duration 1 0 1/1)

mblack = #(ly:make-duration 2 0 1/1) %Blackened M which follows S

SBdottedM = \defineTransform {c'2. d'4}

longaTPMP = #(ly:make-duration -2 0 5/4)

%%% Functions used to define note lengths in minor colouration
sbn = \defineTransform {c'1}

bb = \defineTransform {c'\bblack}
  
sbb = \defineTransform {c'\sbblack}

sbbII = \defineTransform {c'\sbblackII}

mbl = \defineTransform {c'\mblack}

%%% Minor colouration with S and M
sbdm =
#(define-music-function
     (parser location note-I note-II)
     (ly:music? ly:music?)
   #{
  \petrbl <>\startTextSpan \sbb #note-I <>\stopTextSpan \mbl #note-II
  \petrble
#})

%%% Minor colouration with S and M, S inside ligature

lgsbdm = 
#(define-music-function
     (parser location note-I note-II note-III)
     (ly:music? ly:music? ly:music?)
   #{
  \[ #note-I \petrbl \hbd <>\startTextSpan \sbb #note-II <>\stopTextSpan\]
  \mbl #note-III
  \petrble
#})

lsbdm = 
#(define-music-function
     (parser location note-I note-II note-III)
     (ly:music? ly:music? ly:music?)
   #{
  \lgsbdm { \sbn #note-I } #note-II #note-III
#})

%%% Minor colouration with B and S

bdsb =  
#(define-music-function
     (parser location note-I note-II)
     (ly:music? ly:music?)
   #{
  \petrbl <>\startTextSpan \bb #note-I <>\stopTextSpan \sbbII #note-II
  \petrble
#})

bmm =  
#(define-music-function
     (parser location note-I note-II note-III)
     (ly:music? ly:music? ly:music?)
   #{
  \petrbl <>\startTextSpan \bb #note-I \mbl #note-II <>\stopTextSpan
  \mbl #note-III
  \petrble
#})

lgbmm =  
#(define-music-function
     (parser location note-I note-II note-III note-IV)
     (ly:music? ly:music? ly:music? ly:music?)
   #{
  \[ #note-I \petrbl <>\startTextSpan \bb #note-II \]
  \mbl #note-III <>\stopTextSpan
  \mbl #note-IV
  \petrble
#})

%%% Function to typeset correctly M and SM with
%%% empty notehead in prefect prolation
%%% No effect in modern transcrition
wn = {}  

%%% Linebreak for orginial notation, disregarded in modern transcription
newLine = {
  \tag #'ori {\bar "" \break}
}

%%% Layout for polyphony in modern notation
  layoutOne =    \layout {
    \context {
      \Lyrics
      \override LyricText #'font-size = #2.5
      \override LyricText #'font-name = "EB Garamond"
%%%    Code from Lilypond Snippets for Mensurische format
%%%    Doesn't appear to do anything...  
%%%      \consists "Bar_engraver"
%%%      \consists "Separating_line_group_engraver"
    }
    \context {
      \Staff
      \override LigatureBracket.padding = #1
      }
    \context {
      \Score
      %\hide BarLine
      \override BarNumber #'padding = #2
%%% Create padding when lyric extender and hyphens cross barlines
      \override LyricText.layer = #3
      \override LyricHyphen.layer = #2
      \override LyricExtender.stencil = #lyric-extender-in-white-box
      \override LyricHyphen.stencil = #lyric-hyphen-in-white-box
%%% Use the text span object to create colouration brackets
      \override TextSpanner.bound-details.left.text =
      \markup { \combine
		\override #'(thickness . 2)
		\draw-line #'(0 . -1)
		\override #'(thickness . 2)
		\draw-line #'(1 . 0) }
      \override TextSpanner.bound-details.right.text =
      \markup { \combine
		\override #'(thickness . 2)
		\draw-line #'(0 . -1)
		\override #'(thickness . 2)
		\draw-line #'(-1 . 0)}
      \override TextSpanner.style = #'none
      \override TextSpanner.bound-details.right.padding = #-0.7
      \override TextSpanner.bound-details.left.padding = #-0.2
    }
    \context {
      \Voice
      \hide Slur
      \remove "Forbid_line_break_engraver"
      \remove "Rest_engraver"
      \consists "Completion_rest_engraver"
%%% Uncomment for dashed brackets to indicate coniuncturae
%%%      \consists "Horizontal_bracket_engraver"
%%%      \override HorizontalBracket.direction = #UP
%%%      \override HorizontalBracket #'style  = #'dashed-line
%%%      \override HorizontalBracket #'bracket-flare = #'(0 . 0)
    }
    indent = 6\cm
    incipit-width = 4\cm
  }

%%% Layout for typesetting chant in modern notation
layoutTwo =  \layout {
  ragged-last = ##f
  indent = 0\mm
%%%  short-indent = 20\mm
%%%  line-width = 170\mm
  line-thickness = #(/ (ly:output-def-lookup $defaultpaper 'staff-space) 7.0)
  \context {
    \Staff
    \remove "Time_signature_engraver"
				%\remove "Bar_engraver"
    \hide Stem
    \hide BarLine
  }
  \context {
    \Score
    %barAlways = ##t
    \remove "Bar_number_engraver"
  }
}

%%% Paper Layout
paperOne =
\paper {
  #(set-paper-size "letter" 'portrait)
  left-margin = 2\cm
  right-margin = 2\cm
  top-margin = 1\cm
  bottom-margin = 1.5\cm
}

paperFonts = 
\paper {
  #(set-paper-size "letter" 'portrait)
  #(define fonts
    (make-pango-font-tree "Gentium Book Basic"
                          "Nimbus Sans"
                          "Meslo LG L DZ for Powerline"
                          (/ staff-height pt 20)))
}

%%% Division marks taken from from gregorian.ly
%%% This is to prevent the formatting issues if
%%% the entirety ofgregorian.ly was imported
divisioMinima = {
  \once \override BreathingSign.stencil = #ly:breathing-sign::divisio-minima

  % Workaround: add padding.  Correct fix would be spacing engine handle this.
  \once \override BreathingSign.minimum-X-extent = #'(-1.0 . 0.0)
  \once \override BreathingSign.minimum-Y-extent = #'(-2.5 . 2.5)

  \breathe
}
divisioMaior = {
  \once \override BreathingSign.stencil = #ly:breathing-sign::divisio-maior
  \once \override BreathingSign.Y-offset = #0

  % Workaround: add padding.  Correct fix would be spacing engine handle this.
  \once \override BreathingSign.minimum-X-extent = #'(-1.0 . 0.0)
  \once \override BreathingSign.minimum-Y-extent = #'(-2.5 . 2.5)

  \breathe
}
divisioMaxima = {
  \once \override BreathingSign.stencil = #ly:breathing-sign::divisio-maxima
  \once \override BreathingSign.Y-offset = #0

  % Workaround: add padding.  Correct fix would be spacing engine handle this.
  \once \override BreathingSign.minimum-X-extent = #'(-1.0 . 0.0)
  \once \override BreathingSign.minimum-Y-extent = #'(-2.5 . 2.5)

  \breathe
}
finalis = {
  \once \override BreathingSign.stencil = #ly:breathing-sign::finalis
  \once \override BreathingSign.Y-offset = #0

  % Workaround: add padding.  Correct fix would be spacing engine handle this.
  \once \override BreathingSign.minimum-X-extent = #'(-1.0 . 0.0)
  \once \override BreathingSign.minimum-Y-extent = #'(-2.5 . 2.5)

  \breathe
}

%%% A mensural repeat symbol
mensRep = {
  \once \override BreathingSign.stencil = #ly:text-interface::print
  \once \override BreathingSign.text = \markup {
    \lower #0.5
    \combine
    \translate #'(-0.2 . 0):
    \combine 
    \translate #'(0.5 . 0) \musicglyph #"rests.M3mensural"
    \combine
    \translate #'(1 . 0) \musicglyph #"rests.M3mensural"
    \translate #'(1.4 . 0) :
  }
  \once \override BreathingSign.Y-offset = #0

  % Workaround: add padding.  Correct fix would be spacing engine handle this.
  \once \override BreathingSign.minimum-X-extent = #'(-1.0 . 0.0)
  \once \override BreathingSign.minimum-Y-extent = #'(-2.5 . 2.5)

  \breathe
}